/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.layout.AbstractLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStringLayout
extends AbstractLayout<String> {
    private final Charset charset;
    private final StringEncoder encoder;

    protected AbstractStringLayout(Charset charset) {
        this.charset = charset;
        boolean useClass = false;
        try {
            if (String.class.getMethod("getBytes", Charset.class) != null) {
                useClass = true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.encoder = useClass ? new ClassEncoder() : new NameEncoder();
    }

    @Override
    public byte[] toByteArray(LogEvent event) {
        return this.encoder.getBytes((String)this.toSerializable(event));
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    protected Charset getCharset() {
        return this.charset;
    }

    private class NameEncoder
    implements StringEncoder {
        private NameEncoder() {
        }

        public byte[] getBytes(String str) {
            try {
                return str.getBytes(AbstractStringLayout.this.charset.name());
            }
            catch (UnsupportedEncodingException ex) {
                return str.getBytes();
            }
        }
    }

    private class ClassEncoder
    implements StringEncoder {
        private ClassEncoder() {
        }

        public byte[] getBytes(String str) {
            return str.getBytes(AbstractStringLayout.this.charset);
        }
    }

    private static interface StringEncoder {
        public byte[] getBytes(String var1);
    }
}

