/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.css.sac.LexicalUnit;

public class Property {
    private static final String[] BACKGROUND_ATTACHMENT = new String[]{"fixed", "scroll"};
    private static final String[] BACKGROUND_REPEAT = new String[]{"repeat", "repeat-x", "repeat-y", "no-repeat"};
    private static final String[] BORDER_STYLE = new String[]{"none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset"};
    private static final String[] COLORS = new String[]{"aqua", "black", "blue", "fuchsia", "gray", "green", "lime", "maroon", "navy", "olive", "purple", "red", "silver", "teal", "white", "yellow"};
    private static final String[] FONT_SIZE = new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large", "larger", "smaller"};
    private static final String[] FONT_STYLE = new String[]{"normal", "italic", "oblique"};
    private static final String[] FONT_VARIANT = new String[]{"normal", "small-caps"};
    private static final String[] FONT_WEIGHT = new String[]{"normal", "bold", "bolder", "lighter"};
    private static final String[] LIST_STYLE_POSITION = new String[]{"inside", "outside"};
    private static final String[] LIST_STYLE_TYPE = new String[]{"disc", "circle", "square", "decimal", "decimal-leading-zero", "lower-roman", "upper-roman", "lower-greek", "lower-alpha", "lower-latin", "upper-alpha", "upper-latin", "hebrew", "armenian", "georgian", "cjk-ideographic", "hiragana", "katakana", "hiragana-iroha", "katakana-iroha", "none"};
    private static final String[] SYSTEM_FONTS = new String[]{"caption", "icon", "menu", "message-box", "small-caption", "status-bar"};
    private boolean important;
    private String name;
    private Map prefixMap;
    private LexicalUnit value;
    private String valueAsString;

    Property(String name, String value, boolean important, Map prefixMap) {
        this.name = name;
        this.valueAsString = value;
        this.important = important;
        this.prefixMap = prefixMap;
    }

    public Property(String name, LexicalUnit value, boolean important, Map prefixMap) {
        this.name = name;
        this.value = value;
        this.valueAsString = Util.lexicalUnitToString(value, !"font-family".equals(name));
        this.important = important;
        this.prefixMap = prefixMap;
    }

    private Property copy(String name, String value) {
        return new Property(name, value, this.getImportant(), this.getPrefixMap());
    }

    public boolean getImportant() {
        return this.important;
    }

    public String getName() {
        return this.name;
    }

    public LexicalUnit getLexicalUnit() {
        return this.value;
    }

    public Map getPrefixMap() {
        return this.prefixMap;
    }

    public String getValue() {
        return this.valueAsString;
    }

    private static boolean isFontSize(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        return type == 19 || type == 15 || type == 16 || type == 18 || type == 20 || type == 23 || type == 22 || type == 17 || type == 21 || Util.inArray(FONT_SIZE, Util.lexicalUnitAtomLower(unit));
    }

    private static boolean isFontWeight(String atom) {
        try {
            return Util.inArray(FONT_WEIGHT, atom) || Integer.parseInt(atom) >= 100 && Integer.parseInt(atom) <= 900;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private Property[] setAtoms(String[] names, String[] atoms) {
        Property[] result = new Property[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = this.copy(names[i], atoms[i]);
        }
        return result;
    }

    public Property[] split() {
        StringTokenizer tokenizer = new StringTokenizer(this.getName(), "-");
        String name = "split";
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            name = name + token.substring(0, 1).toUpperCase() + token.substring(1);
        }
        try {
            return (Property[])this.getClass().getDeclaredMethod(name, new Class[0]).invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (InvocationTargetException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (NoSuchMethodException e) {
            return new Property[]{this};
        }
    }

    private Property[] splitBackground() {
        ArrayList<Property> result = new ArrayList<Property>();
        String remaining = null;
        for (LexicalUnit i = this.value; i != null; i = i.getNextLexicalUnit()) {
            String atom = Util.lexicalUnitAtomLower(i);
            if (i.getLexicalUnitType() == 24) {
                result.add(this.copy("background-image", atom));
                continue;
            }
            if (i.getLexicalUnitType() == 27 || Util.inArray(COLORS, atom)) {
                result.add(this.copy("background-color", atom));
                continue;
            }
            if (Util.inArray(BACKGROUND_ATTACHMENT, atom)) {
                result.add(this.copy("background-attachment", atom));
                continue;
            }
            if (Util.inArray(BACKGROUND_REPEAT, atom)) {
                result.add(this.copy("background-repeat", atom));
                continue;
            }
            remaining = remaining == null ? atom : remaining + " " + atom;
        }
        if (remaining != null) {
            result.add(this.copy("background-position", remaining));
        }
        return result.toArray(new Property[result.size()]);
    }

    private Property[] splitBorder() {
        ArrayList<Property> result = new ArrayList<Property>();
        String remaining = null;
        for (LexicalUnit i = this.value; i != null; i = i.getNextLexicalUnit()) {
            String atom = Util.lexicalUnitAtomLower(i);
            if (i.getLexicalUnitType() == 27 || Util.inArray(COLORS, atom) || atom.equals("transparant")) {
                result.add(this.copy("border-top-color", atom));
                result.add(this.copy("border-bottom-color", atom));
                result.add(this.copy("border-left-color", atom));
                result.add(this.copy("border-right-color", atom));
                continue;
            }
            if (Util.inArray(BORDER_STYLE, atom)) {
                result.add(this.copy("border-top-style", atom));
                result.add(this.copy("border-bottom-style", atom));
                result.add(this.copy("border-left-style", atom));
                result.add(this.copy("border-right-style", atom));
                continue;
            }
            remaining = remaining == null ? atom : remaining + " " + atom;
        }
        if (remaining != null) {
            result.add(this.copy("border-top-width", remaining));
            result.add(this.copy("border-bottom-width", remaining));
            result.add(this.copy("border-left-width", remaining));
            result.add(this.copy("border-right-width", remaining));
            result.add(this.copy("border-after-width.conditionality", "retain"));
            result.add(this.copy("border-before-width.conditionality", "retain"));
        }
        return result.toArray(new Property[result.size()]);
    }

    private Property[] splitBorderBottom() {
        return this.splitBorderSide("bottom");
    }

    private Property[] splitBorderBottomWidth() {
        Property[] result = new Property[]{this.copy(this.getName(), this.getValue()), this.copy("border-after-width.conditionality", "retain")};
        return result;
    }

    private Property[] splitBorderColor() {
        return this.splitFourWays(this.getName(), this.getImportant());
    }

    private Property[] splitBorderLeft() {
        return this.splitBorderSide("left");
    }

    private Property[] splitBorderRight() {
        return this.splitBorderSide("right");
    }

    private Property[] splitBorderStyle() {
        return this.splitFourWays(this.getName(), this.getImportant());
    }

    private Property[] splitBorderTop() {
        return this.splitBorderSide("top");
    }

    private Property[] splitBorderSide(String side) {
        ArrayList<Property> result = new ArrayList<Property>();
        String remaining = null;
        for (LexicalUnit i = this.value; i != null; i = i.getNextLexicalUnit()) {
            String atom = Util.lexicalUnitAtomLower(i);
            if (i.getLexicalUnitType() == 27 || Util.inArray(COLORS, atom) || atom.equals("transparant")) {
                result.add(this.copy("border-" + side + "-color", atom));
                continue;
            }
            if (Util.inArray(BORDER_STYLE, atom)) {
                result.add(this.copy("border-" + side + "-style", atom));
                continue;
            }
            remaining = remaining == null ? atom : remaining + " " + atom;
        }
        if (remaining != null) {
            result.add(this.copy("border-" + side + "-width", remaining));
            if ("top".equals(side)) {
                result.add(this.copy("border-before-width.conditionality", "retain"));
            } else if ("bottom".equals(side)) {
                result.add(this.copy("border-after-width.conditionality", "retain"));
            }
        }
        return result.toArray(new Property[result.size()]);
    }

    private Property[] splitBorderTopWidth() {
        Property[] result = new Property[]{this.copy(this.getName(), this.getValue()), this.copy("border-before-width.conditionality", "retain")};
        return result;
    }

    private Property[] splitBorderWidth() {
        Property[] values = this.splitFourWays(this.getName(), this.getImportant());
        Property[] result = new Property[values.length + 2];
        System.arraycopy(values, 0, result, 0, values.length);
        result[values.length] = this.copy("border-after-width.conditionality", "retain");
        result[values.length + 1] = this.copy("border-before-width.conditionality", "retain");
        return result;
    }

    private Property[] splitFont() {
        ArrayList<Property> result = new ArrayList<Property>();
        String remaining = null;
        for (LexicalUnit i = this.value; i != null; i = i.getNextLexicalUnit()) {
            String originalAtom = Util.lexicalUnitAtom(i);
            String atom = originalAtom.toLowerCase();
            if (Util.inArray(SYSTEM_FONTS, atom)) {
                result.add(this.copy("font", atom));
                continue;
            }
            if (Util.inArray(FONT_STYLE, atom)) {
                result.add(this.copy("font-style", atom));
                continue;
            }
            if (Util.inArray(FONT_VARIANT, atom)) {
                result.add(this.copy("font-variant", atom));
                continue;
            }
            if (Property.isFontWeight(atom)) {
                result.add(this.copy("font-weight", atom));
                continue;
            }
            if ((i.getPreviousLexicalUnit() == null || i.getPreviousLexicalUnit().getLexicalUnitType() != 4) && Property.isFontSize(i)) {
                result.add(this.copy("font-size", atom));
                continue;
            }
            if (i.getLexicalUnitType() == 4) {
                i = i.getNextLexicalUnit();
                result.add(this.copy("line-height", Util.lexicalUnitAtomLower(i)));
                continue;
            }
            remaining = remaining == null ? originalAtom : remaining + " " + originalAtom;
        }
        if (remaining != null) {
            result.add(this.copy("font-family", remaining));
        }
        return result.toArray(new Property[result.size()]);
    }

    private Property[] splitFourWays(String name, boolean important) {
        String[] names = Property.splitFourWaysNames(name);
        LexicalUnit[] units = Util.lexicalUnitArray(this.value);
        if (units.length == 1) {
            String atom = Util.lexicalUnitAtomLower(units[0]);
            return this.setAtoms(names, new String[]{atom, atom, atom, atom});
        }
        if (units.length == 2) {
            String atom1 = Util.lexicalUnitAtomLower(units[0]);
            String atom2 = Util.lexicalUnitAtomLower(units[1]);
            return this.setAtoms(names, new String[]{atom1, atom1, atom2, atom2});
        }
        if (units.length == 3) {
            String atom1 = Util.lexicalUnitAtomLower(units[0]);
            String atom2 = Util.lexicalUnitAtomLower(units[1]);
            String atom3 = Util.lexicalUnitAtomLower(units[2]);
            return this.setAtoms(names, new String[]{atom1, atom3, atom2, atom2});
        }
        if (units.length == 4) {
            String atom1 = Util.lexicalUnitAtomLower(units[0]);
            String atom2 = Util.lexicalUnitAtomLower(units[1]);
            String atom3 = Util.lexicalUnitAtomLower(units[2]);
            String atom4 = Util.lexicalUnitAtomLower(units[3]);
            return this.setAtoms(names, new String[]{atom1, atom2, atom3, atom4});
        }
        return new Property[]{this};
    }

    private static String[] splitFourWaysNames(String name) {
        String[] result = new String[4];
        StringTokenizer tokenizer = new StringTokenizer(name, "-");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (result[0] == null) {
                result[0] = token + "-top";
                result[1] = token + "-bottom";
                result[2] = token + "-left";
                result[3] = token + "-right";
                continue;
            }
            int i = 0;
            while (i < result.length) {
                int n = i++;
                result[n] = result[n] + "-" + token;
            }
        }
        return result;
    }

    private Property[] splitListStyle() {
        ArrayList<Property> result = new ArrayList<Property>();
        for (LexicalUnit i = this.value; i != null; i = i.getNextLexicalUnit()) {
            String atom = Util.lexicalUnitAtomLower(i);
            if (atom.equals("none")) {
                result.add(this.copy("list-style-type", atom));
                result.add(this.copy("list-style-image", atom));
                continue;
            }
            if (i.getLexicalUnitType() == 24) {
                result.add(this.copy("list-style-image", atom));
                continue;
            }
            if (Util.inArray(LIST_STYLE_POSITION, atom)) {
                result.add(this.copy("list-style-position", atom));
                continue;
            }
            if (!Util.inArray(LIST_STYLE_TYPE, atom)) continue;
            result.add(this.copy("list-style-type", atom));
        }
        return result.toArray(new Property[result.size()]);
    }

    private Property[] splitMargin() {
        return this.splitFourWays(this.getName(), this.getImportant());
    }

    private Property[] splitPadding() {
        return this.splitFourWays(this.getName(), this.getImportant());
    }
}

