/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.flute.parser;

import org.w3c.css.sac.LexicalUnit;
import org.w3c.flute.parser.ParseException;

class LexicalUnitImpl
implements LexicalUnit {
    LexicalUnit prev;
    LexicalUnit next;
    short type;
    int line;
    int column;
    int i;
    float f;
    short dimension;
    String sdimension;
    String s;
    String fname;
    LexicalUnitImpl params;

    LexicalUnitImpl(short type, int line, int column, LexicalUnitImpl p) {
        if (p != null) {
            this.prev = p;
            p.next = this;
        }
        this.line = line;
        this.column = column - 1;
        this.type = type;
    }

    LexicalUnitImpl(int line, int column, LexicalUnitImpl previous, int i) {
        this(13, line, column, previous);
        this.i = i;
    }

    LexicalUnitImpl(int line, int column, LexicalUnitImpl previous, short dimension, String sdimension, float f) {
        this(dimension, line, column, previous);
        this.f = f;
        this.dimension = dimension;
        this.sdimension = sdimension;
    }

    LexicalUnitImpl(int line, int column, LexicalUnitImpl previous, short type, String s) {
        this(type, line, column, previous);
        this.s = s;
    }

    LexicalUnitImpl(short type, int line, int column, LexicalUnitImpl previous, String fname, LexicalUnitImpl params) {
        this(type, line, column, previous);
        this.fname = fname;
        this.params = params;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public short getLexicalUnitType() {
        return this.type;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.next;
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this.prev;
    }

    public int getIntegerValue() {
        return this.i;
    }

    void setIntegerValue(int i) {
        this.i = i;
    }

    public float getFloatValue() {
        return this.f;
    }

    void setFloatValue(float f) {
        this.f = f;
    }

    public String getDimensionUnitText() {
        switch (this.type) {
            case 23: {
                return "%";
            }
            case 15: {
                return "em";
            }
            case 16: {
                return "ex";
            }
            case 17: {
                return "px";
            }
            case 19: {
                return "cm";
            }
            case 20: {
                return "mm";
            }
            case 18: {
                return "in";
            }
            case 21: {
                return "pt";
            }
            case 22: {
                return "pc";
            }
            case 28: {
                return "deg";
            }
            case 30: {
                return "rad";
            }
            case 29: {
                return "grad";
            }
            case 31: {
                return "ms";
            }
            case 32: {
                return "s";
            }
            case 33: {
                return "Hz";
            }
            case 34: {
                return "kHz";
            }
            case 42: {
                return this.sdimension;
            }
        }
        throw new IllegalStateException("invalid dimension " + this.type);
    }

    public String getStringValue() {
        return this.s;
    }

    public String getFunctionName() {
        return this.fname;
    }

    public LexicalUnit getParameters() {
        return this.params;
    }

    public LexicalUnit getSubValues() {
        return this.params;
    }

    public String toString() {
        String text;
        switch (this.type) {
            case 0: {
                text = ",";
                break;
            }
            case 1: {
                text = "+";
                break;
            }
            case 2: {
                text = "-";
                break;
            }
            case 3: {
                text = "*";
                break;
            }
            case 4: {
                text = "/";
                break;
            }
            case 5: {
                text = "%";
                break;
            }
            case 6: {
                text = "^";
                break;
            }
            case 7: {
                text = "<";
                break;
            }
            case 8: {
                text = ">";
                break;
            }
            case 9: {
                text = "<=";
                break;
            }
            case 10: {
                text = "=>";
                break;
            }
            case 11: {
                text = "~";
                break;
            }
            case 12: {
                text = "inherit";
                break;
            }
            case 13: {
                text = Integer.toString(this.i, 10);
                break;
            }
            case 14: {
                text = this.f + "";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                Object fs = null;
                int i = (int)this.f;
                if ((float)i == this.f) {
                    text = i + this.getDimensionUnitText();
                    break;
                }
                text = this.f + this.getDimensionUnitText();
                break;
            }
            case 24: {
                text = "uri(" + this.s + ")";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 38: 
            case 41: {
                text = this.getFunctionName() + "(" + this.getParameters() + ")";
                break;
            }
            case 35: {
                text = "attr(" + this.getStringValue() + ")";
                break;
            }
            case 36: {
                text = "\"" + this.getStringValue() + "\"";
                break;
            }
            case 37: {
                text = "attr(" + this.getStringValue() + ")";
                break;
            }
            case 39: {
                text = "@@TODO";
                break;
            }
            case 40: {
                text = this.getSubValues().toString();
                break;
            }
            default: {
                text = "@unknown";
            }
        }
        if (this.next != null) {
            return text + ' ' + this.next;
        }
        return text;
    }

    static LexicalUnitImpl createNumber(int line, int column, LexicalUnitImpl previous, float v) {
        int i = (int)v;
        if (v == (float)i) {
            return new LexicalUnitImpl(line, column, previous, i);
        }
        return new LexicalUnitImpl(line, column, previous, 14, "", v);
    }

    static LexicalUnitImpl createInteger(int line, int column, LexicalUnitImpl previous, int i) {
        return new LexicalUnitImpl(line, column, previous, i);
    }

    static LexicalUnitImpl createPercentage(int line, int column, LexicalUnitImpl previous, float v) {
        return new LexicalUnitImpl(line, column, previous, 23, null, v);
    }

    static LexicalUnitImpl createEMS(int line, int column, LexicalUnitImpl previous, float v) {
        return new LexicalUnitImpl(line, column, previous, 15, null, v);
    }

    static LexicalUnitImpl createEXS(int line, int column, LexicalUnitImpl previous, float v) {
        return new LexicalUnitImpl(line, column, previous, 16, null, v);
    }

    static LexicalUnitImpl createPX(int line, int column, LexicalUnitImpl previous, float v) {
        return new LexicalUnitImpl(line, column, previous, 17, null, v);
    }

    static LexicalUnitImpl createCM(int line, int column, LexicalUnitImpl previous, float v) {
        return new LexicalUnitImpl(line, column, previous, 19, null, v);
    }

    static LexicalUnitImpl createMM(int line, int column, LexicalUnitImpl previous, float v) {
        return new LexicalUnitImpl(line, column, previous, 20, null, v);
    }

    static LexicalUnitImpl createIN(int line, int column, LexicalUnitImpl previous, float v) {
        return new LexicalUnitImpl(line, column, previous, 18, null, v);
    }

    static LexicalUnitImpl createPT(int line, int column, LexicalUnitImpl previous, float v) {
        return new LexicalUnitImpl(line, column, previous, 21, null, v);
    }

    static LexicalUnitImpl createPC(int line, int column, LexicalUnitImpl previous, float v) {
        return new LexicalUnitImpl(line, column, previous, 22, null, v);
    }

    static LexicalUnitImpl createDEG(int line, int column, LexicalUnitImpl previous, float v) {
        return new LexicalUnitImpl(line, column, previous, 28, null, v);
    }

    static LexicalUnitImpl createRAD(int line, int column, LexicalUnitImpl previous, float v) {
        return new LexicalUnitImpl(line, column, previous, 30, null, v);
    }

    static LexicalUnitImpl createGRAD(int line, int column, LexicalUnitImpl previous, float v) {
        return new LexicalUnitImpl(line, column, previous, 29, null, v);
    }

    static LexicalUnitImpl createMS(int line, int column, LexicalUnitImpl previous, float v) {
        if (v < 0.0f) {
            throw new ParseException("Time values may not be negative");
        }
        return new LexicalUnitImpl(line, column, previous, 31, null, v);
    }

    static LexicalUnitImpl createS(int line, int column, LexicalUnitImpl previous, float v) {
        if (v < 0.0f) {
            throw new ParseException("Time values may not be negative");
        }
        return new LexicalUnitImpl(line, column, previous, 32, null, v);
    }

    static LexicalUnitImpl createHZ(int line, int column, LexicalUnitImpl previous, float v) {
        if (v < 0.0f) {
            throw new ParseException("Frequency values may not be negative");
        }
        return new LexicalUnitImpl(line, column, previous, 33, null, v);
    }

    static LexicalUnitImpl createKHZ(int line, int column, LexicalUnitImpl previous, float v) {
        if (v < 0.0f) {
            throw new ParseException("Frequency values may not be negative");
        }
        return new LexicalUnitImpl(line, column, previous, 34, null, v);
    }

    static LexicalUnitImpl createDimen(int line, int column, LexicalUnitImpl previous, float v, String s) {
        return new LexicalUnitImpl(line, column, previous, 42, s, v);
    }

    static LexicalUnitImpl createInherit(int line, int column, LexicalUnitImpl previous) {
        return new LexicalUnitImpl(line, column, previous, 12, "inherit");
    }

    static LexicalUnitImpl createIdent(int line, int column, LexicalUnitImpl previous, String s) {
        return new LexicalUnitImpl(line, column, previous, 35, s);
    }

    static LexicalUnitImpl createPrefixedIdent(int line, int column, LexicalUnitImpl previous, String s) {
        return new LexicalUnitImpl(line, column, previous, 43, s);
    }

    static LexicalUnitImpl createString(int line, int column, LexicalUnitImpl previous, String s) {
        return new LexicalUnitImpl(line, column, previous, 36, s);
    }

    static LexicalUnitImpl createURL(int line, int column, LexicalUnitImpl previous, String s) {
        return new LexicalUnitImpl(line, column, previous, 24, s);
    }

    static LexicalUnitImpl createAttr(int line, int column, LexicalUnitImpl previous, String s) {
        return new LexicalUnitImpl(line, column, previous, 37, s);
    }

    static LexicalUnitImpl createCounter(int line, int column, LexicalUnitImpl previous, LexicalUnit params) {
        return new LexicalUnitImpl(25, line, column, previous, "counter", (LexicalUnitImpl)params);
    }

    static LexicalUnitImpl createCounters(int line, int column, LexicalUnitImpl previous, LexicalUnit params) {
        return new LexicalUnitImpl(26, line, column, previous, "counters", (LexicalUnitImpl)params);
    }

    static LexicalUnitImpl createRGBColor(int line, int column, LexicalUnitImpl previous, LexicalUnit params) {
        return new LexicalUnitImpl(27, line, column, previous, "color", (LexicalUnitImpl)params);
    }

    static LexicalUnitImpl createRect(int line, int column, LexicalUnitImpl previous, LexicalUnit params) {
        return new LexicalUnitImpl(38, line, column, previous, "rect", (LexicalUnitImpl)params);
    }

    static LexicalUnitImpl createFunction(int line, int column, LexicalUnitImpl previous, String fname, LexicalUnit params) {
        return new LexicalUnitImpl(41, line, column, previous, fname, (LexicalUnitImpl)params);
    }

    static LexicalUnitImpl createUnicodeRange(int line, int column, LexicalUnit previous, LexicalUnit params) {
        return null;
    }

    static LexicalUnitImpl createComma(int line, int column, LexicalUnitImpl previous) {
        return new LexicalUnitImpl(0, line, column, previous);
    }

    static LexicalUnitImpl createSlash(int line, int column, LexicalUnitImpl previous) {
        return new LexicalUnitImpl(4, line, column, previous);
    }
}

