/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Constants;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class BlockContainerFilter
extends XMLFilterImpl {
    private static final Set containerProperties = new HashSet<String>(Arrays.asList("bottom", "clip", "height", "left", "max-height", "max-width", "min-height", "min-width", "orientation", "overflow", "position", "right", "top", "width", "z-index"));
    private static final Set triggeringBlockProperties = new HashSet<String>(Arrays.asList("clip", "height", "max-height", "max-width", "min-height", "min-width", "orientation", "overflow", "width", "z-index"));
    private Stack stack = new Stack();

    BlockContainerFilter() {
    }

    BlockContainerFilter(XMLReader parent) {
        super(parent);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        if (this.stack.pop().equals(new Boolean(true))) {
            super.endElement(Constants.XSLFO, "block", "fo:block");
            super.endElement(Constants.XSLFO, "block-container", "fo:block-container");
        }
    }

    private static boolean isContainerAttribute(Attributes atts, int index) {
        String name = atts.getLocalName(index);
        return Constants.CSS.equals(atts.getURI(index)) && (containerProperties.contains(name) || name.startsWith("background-") || name.startsWith("border-") || name.startsWith("margin-") || name.startsWith("padding-") || name.startsWith("page-break-"));
    }

    private static AttributesImpl selectAttributes(Attributes atts, boolean container) {
        AttributesImpl result = new AttributesImpl();
        for (int i = 0; i < atts.getLength(); ++i) {
            if (container != BlockContainerFilter.isContainerAttribute(atts, i)) continue;
            result.addAttribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getType(i), atts.getValue(i));
        }
        return result;
    }

    private static boolean shouldWrap(Attributes atts) {
        boolean block = "block".equals(atts.getValue(Constants.CSS, "display"));
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!Constants.CSS.equals(atts.getURI(i)) || (!block || !triggeringBlockProperties.contains(atts.getLocalName(i))) && (!"position".equals(atts.getLocalName(i)) || !"absolute".equals(atts.getValue(i)) && !"fixed".equals(atts.getValue(i)))) continue;
            return true;
        }
        return false;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        boolean wrap = BlockContainerFilter.shouldWrap(atts);
        if (wrap) {
            super.startElement(Constants.XSLFO, "block-container", "fo:block-container", BlockContainerFilter.selectAttributes(atts, true));
            super.startElement(Constants.XSLFO, "block", "fo:block", new AttributesImpl());
        }
        super.startElement(namespaceURI, localName, qName, wrap ? BlockContainerFilter.selectAttributes(atts, false) : atts);
        this.stack.push(new Boolean(wrap));
    }
}

