/*
 * Decompiled with CFR 0.152.
 */
package be.re.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamConnector {
    private IOException exception = null;
    private Thread thread;

    public StreamConnector(InputStream in, OutputStream out) {
        this(in, out, true, true);
    }

    public StreamConnector(InputStream in, OutputStream out, boolean closeInput, boolean closeOutput) {
        this(in, out, 65536, closeInput, closeOutput);
    }

    public StreamConnector(final InputStream in, final OutputStream out, final int bufferSize, final boolean closeInput, final boolean closeOutput) {
        this.thread = new Thread(new Runnable(){

            public void run() {
                try {
                    StreamConnector.copy(in, out, bufferSize, closeInput, closeOutput);
                }
                catch (IOException e) {
                    StreamConnector.this.exception = e;
                }
            }
        });
        this.thread.start();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        StreamConnector.copy(in, out, true, true);
    }

    public static void copy(InputStream in, OutputStream out, boolean closeInput, boolean closeOutput) throws IOException {
        StreamConnector.copy(in, out, 65536, closeInput, closeOutput);
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize, boolean closeInput, boolean closeOutput) throws IOException {
        int len;
        byte[] buffer = new byte[bufferSize];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
            out.flush();
        }
        if (closeInput) {
            in.close();
        }
        if (closeOutput) {
            out.close();
        } else {
            out.flush();
        }
    }

    public void disconnect() {
        this.thread.interrupt();
    }

    public void join() throws IOException, InterruptedException {
        this.thread.join();
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

