/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Compiled;
import be.re.css.Constants;
import be.re.css.Context;
import be.re.css.Matcher;
import be.re.css.Property;
import be.re.css.Rule;
import be.re.css.RuleCollector;
import be.re.css.Util;
import be.re.xml.Accumulator;
import be.re.xml.DOMToContentHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class ProjectorFilter
extends XMLFilterImpl {
    private static final String DEFAULT_CLOSE_QUOTE = "\"";
    private static final String DEFAULT_OPEN_QUOTE = "\"";
    private static final String AFTER = "after".intern();
    private static final String BASE = "base".intern();
    private static final String BEFORE = "before".intern();
    private static final String BODY = "body".intern();
    private static final String FIRST_LETTER = "first-letter".intern();
    private static final String FIRST_LINE = "first-line".intern();
    private static final String LINK = "link".intern();
    private static final String STYLE = "style".intern();
    private static final String[][] pageFormatTable = new String[][]{{"armenian", "&#x0561;"}, {"decimal", "1"}, {"decimal-leading-zero", "01"}, {"georgian", "&#x10D0;"}, {"hebrew", "&#x05D0;"}, {"hiragana", "&#x3042;"}, {"hiragana-iroha", "&#x3044;"}, {"katakana", "&#x30A2;"}, {"katakana-iroha", "&#x30A4;"}, {"lower-alpha", "a"}, {"lower-greek", "&#x03B1;"}, {"lower-latin", "a"}, {"lower-roman", "i"}, {"upper-alpha", "A"}, {"upper-latin", "A"}, {"upper-roman", "I"}};
    private URL baseUrl = null;
    private boolean collectStyleSheet = false;
    private Compiled compiled = new Compiled();
    private Context context;
    private Stack counters = new Stack();
    private URL defaultBaseUrl = null;
    private Stack elements = new Stack();
    private String embeddedStyleSheet = "";
    private int lastRulePosition = 0;
    private Matcher matcher = null;
    private Stack namedStrings = new Stack();
    private int quoteDepth = 0;
    private Map userAgentParameters;
    private URL userAgentStyleSheet = null;

    ProjectorFilter(Context context) {
        this(null, null, new HashMap(), context);
    }

    ProjectorFilter(URL baseUrl, URL userAgentStyleSheet, Map userAgentParameters, Context context) {
        this.baseUrl = baseUrl;
        this.defaultBaseUrl = baseUrl;
        this.userAgentStyleSheet = userAgentStyleSheet != null ? userAgentStyleSheet : this.getClass().getResource("style/ua.css");
        this.userAgentParameters = userAgentParameters;
        this.context = context;
    }

    private static void addFOMarker(Node parent, String name, String value) {
        org.w3c.dom.Element element = parent.getOwnerDocument().createElementNS(Constants.CSS, "css:fo-marker");
        element.appendChild(parent.getOwnerDocument().createTextNode(value));
        element.setAttributeNS(Constants.CSS, "css:name", name);
        parent.insertBefore(element, parent.getFirstChild());
    }

    private Rule[] appendStyleAttributeRules(Rule[] matchingRules, Attributes atts, String namespaceURI) throws SAXException {
        if (Constants.XHTML != namespaceURI) {
            return matchingRules;
        }
        String style = atts.getValue("style");
        if (style == null || "".equals(style)) {
            return matchingRules;
        }
        try {
            Rule[] rules = this.getStyleAttributeRules(style);
            Rule[] result = new Rule[matchingRules.length + rules.length];
            System.arraycopy(matchingRules, 0, result, 0, matchingRules.length);
            System.arraycopy(rules, 0, result, matchingRules.length, rules.length);
            return result;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void applyContentProperty(Element element, Rule[] pseudoRules) throws SAXException {
        boolean seen = false;
        for (int i = pseudoRules.length - 1; i >= 0 && !seen; --i) {
            Property[] properties = pseudoRules[i].getProperties();
            for (int j = 0; j < properties.length && !seen; ++j) {
                if (!"content".equals(properties[j].getName()) || properties[j].getLexicalUnit().getLexicalUnitType() == 12) continue;
                seen = true;
                block11: for (LexicalUnit k = properties[j].getLexicalUnit(); k != null; k = k.getNextLexicalUnit()) {
                    switch (k.getLexicalUnitType()) {
                        case 37: {
                            this.serializeAttrFunction(k, element, properties[j].getPrefixMap());
                            continue block11;
                        }
                        case 25: {
                            this.serializeCounterFunction(k);
                            continue block11;
                        }
                        case 26: {
                            this.serializeCountersFunction(k);
                            continue block11;
                        }
                        case 41: {
                            this.serializeFunction(k, element, properties[j].getPrefixMap());
                            continue block11;
                        }
                        case 35: {
                            this.serializeQuote(k, element);
                            continue block11;
                        }
                        case 36: {
                            this.serializeString(k.getStringValue());
                            continue block11;
                        }
                        case 24: {
                            this.serializeUriFunction(k);
                            continue block11;
                        }
                    }
                }
            }
        }
    }

    private void addFirstLetterMarker(Element element) {
        Rule[] pseudoRules = ProjectorFilter.selectPseudoRules(element.matchingPseudoRules, FIRST_LETTER);
        if (pseudoRules.length > 0) {
            element.appliedAttributes.addAttribute(Constants.CSS, "has-first-letter", "css:has-first-letter", "CDATA", "1");
        }
    }

    private void applyPseudoRules(Element element, String name) throws SAXException {
        Rule[] pseudoRules = ProjectorFilter.selectPseudoRules(element.matchingPseudoRules, name);
        if (pseudoRules.length > 0) {
            AttributesImpl extra = new AttributesImpl();
            if (AFTER == name || BEFORE == name) {
                extra.addAttribute(Constants.CSS, "display", "css:display", "CDATA", "inline");
            }
            AttributesImpl attributes = this.setCSSAttributes(pseudoRules, extra);
            AttributesImpl changeBarAttributes = ProjectorFilter.splitChangeBarAttributes(attributes);
            if (BEFORE == name) {
                this.serializeChangeBarBegin(changeBarAttributes);
            }
            super.startElement(Constants.CSS, name, "css:" + name, attributes);
            if (AFTER == name || BEFORE == name) {
                this.serializeFOMarkers(pseudoRules);
                this.applyContentProperty(element, pseudoRules);
            }
            super.endElement(Constants.CSS, name, "css:" + name);
            if (AFTER == name) {
                this.serializeChangeBarEnd(changeBarAttributes);
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.collectStyleSheet) {
            this.embeddedStyleSheet = this.embeddedStyleSheet + new String(ch, start, length);
        }
        super.characters(ch, start, length);
    }

    private static String convertPageFormat(String listStyle) {
        for (int i = 0; i < pageFormatTable.length; ++i) {
            if (!listStyle.equals(pageFormatTable[i][0])) continue;
            return pageFormatTable[i][1];
        }
        return "1";
    }

    private static void detectMarkers(Element element) {
        boolean hasMarkers = false;
        for (int i = 0; i < element.matchingPseudoRules.length && !hasMarkers; ++i) {
            hasMarkers = (element.matchingPseudoRules[i].getPseudoElementName() == BEFORE || element.matchingPseudoRules[i].getPseudoElementName() == AFTER) && "display".equals(element.matchingPseudoRules[i].getProperty().getName()) && "marker".equals(element.matchingPseudoRules[i].getProperty().getValue());
        }
        if (hasMarkers) {
            element.appliedAttributes.addAttribute(Constants.CSS, "has-markers", "css:has-markers", "CDATA", "1");
        }
    }

    public void endDocument() throws SAXException {
        this.endPrefixMapping("css");
        this.endPrefixMapping("sp");
        super.endDocument();
        this.matcher.endDocument();
        this.reset();
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.counters.pop();
        this.namedStrings.pop();
        this.matcher.endElement(namespaceURI, localName, qName);
        if (this.collectStyleSheet) {
            this.collectStyleSheet = false;
            try {
                this.parseStyleSheet(new StringReader(this.embeddedStyleSheet), 0, true);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
            this.embeddedStyleSheet = "";
        }
        Element element = (Element)this.elements.pop();
        this.applyPseudoRules(element, AFTER);
        super.endElement(element.namespaceURI, element.localName, element.qName);
        Element.access$502(element, null);
        Element.access$002(element, null);
        element.appliedAttributes = null;
        if (element.floating) {
            super.endElement(Constants.CSS, "float", "css:float");
        }
    }

    private static String evaluateAttrFunction(LexicalUnit function, Attributes attributes, Map prefixMap) {
        if (function.getStringValue() == null) {
            return "";
        }
        String attribute = function.getStringValue();
        int index = attribute.indexOf(124);
        String value = index == -1 ? attributes.getValue(attribute) : attributes.getValue((String)prefixMap.get(attribute.substring(0, index)), attribute.substring(index + 1));
        return value != null ? value : "";
    }

    private String evaluateCounterFunction(LexicalUnit function) {
        if (function.getParameters() == null) {
            return "";
        }
        String counter = function.getParameters().getStringValue();
        if (counter == null) {
            return "";
        }
        Integer value = (Integer)this.findCounterScope(counter).get(counter.toLowerCase());
        String listStyle = ProjectorFilter.getCounterListStyle(function);
        return value != null && !"none".equalsIgnoreCase(listStyle) && !"inherit".equalsIgnoreCase(listStyle) ? ProjectorFilter.getCounterString(value, listStyle) : "";
    }

    private String evaluateCountersFunction(LexicalUnit function) throws SAXException {
        if (function.getParameters() == null) {
            return "";
        }
        String counter = function.getParameters().getStringValue();
        if (counter == null) {
            return "";
        }
        LexicalUnit parameter = function.getParameters().getNextLexicalUnit().getNextLexicalUnit();
        if (parameter == null) {
            return "";
        }
        String separator = parameter.getStringValue();
        if (separator == null) {
            return "";
        }
        String listStyle = ProjectorFilter.getCountersListStyle(parameter);
        return !"none".equalsIgnoreCase(listStyle) && !"inherit".equalsIgnoreCase(listStyle) ? this.getCountersString(counter.toLowerCase(), separator, listStyle) : "";
    }

    private static String evaluateQuote(LexicalUnit quote, Element element, int[] quoteDepth) {
        if (quote.getStringValue().equals("open-quote")) {
            String s = ProjectorFilter.selectOpenQuote(element, quoteDepth[0]);
            quoteDepth[0] = quoteDepth[0] + 1;
            return s;
        }
        if (quote.getStringValue().equals("close-quote")) {
            quoteDepth[0] = quoteDepth[0] - 1;
            String s = ProjectorFilter.selectCloseQuote(element, quoteDepth[0]);
            return s;
        }
        if (quote.getStringValue().equals("no-open-quote")) {
            quoteDepth[0] = quoteDepth[0] + 1;
        } else if (quote.getStringValue().equals("no-close-quote")) {
            quoteDepth[0] = quoteDepth[0] - 1;
        }
        return "";
    }

    private String evaluateStringFunction(LexicalUnit function) throws SAXException {
        if (function.getParameters() == null) {
            return "";
        }
        String name = function.getParameters().getStringValue().toLowerCase();
        String value = (String)this.findNamedStringScope(name).get(name);
        return value != null ? value : "";
    }

    private Map findCounterScope(String counter) {
        return ProjectorFilter.findScope(this.counters, counter, new Integer(0));
    }

    private Map findNamedStringScope(String namedString) {
        return ProjectorFilter.findScope(this.namedStrings, namedString, "");
    }

    private static Map findScope(Stack scopes, String item, Object defaultValue) {
        for (int i = scopes.size() - 1; i >= 0; --i) {
            if (!((Map)scopes.get(i)).containsKey(item)) continue;
            return (Map)scopes.get(i);
        }
        ((Map)scopes.get(0)).put(item, defaultValue);
        return (Map)scopes.get(0);
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    private static String getCounterListStyle(LexicalUnit function) {
        return function.getParameters().getNextLexicalUnit() != null && function.getParameters().getNextLexicalUnit().getLexicalUnitType() == 0 ? function.getParameters().getNextLexicalUnit().getNextLexicalUnit().getStringValue() : "decimal";
    }

    private static String getCountersListStyle(LexicalUnit function) {
        return function.getNextLexicalUnit() != null && function.getNextLexicalUnit().getLexicalUnitType() == 0 ? function.getNextLexicalUnit().getNextLexicalUnit().getStringValue() : "decimal";
    }

    private static String getCounterString(int value, String listStyle) {
        if (listStyle.equals("circle")) {
            return "\u25cb";
        }
        if (listStyle.equals("disc")) {
            return "\u2022";
        }
        if (listStyle.equals("square")) {
            return "\u25a0";
        }
        if (listStyle.equals("decimal-leading-zero")) {
            return (value < 10 ? "0" : "") + String.valueOf(value);
        }
        if (listStyle.equals("lower-alpha") || listStyle.equals("lower-latin")) {
            return String.valueOf((char)(value + 96));
        }
        if (listStyle.equals("upper-alpha") || listStyle.equals("upper-latin")) {
            return String.valueOf((char)(value + 64));
        }
        if (listStyle.equals("lower-greek")) {
            return String.valueOf((char)(value + 944));
        }
        if (listStyle.equals("lower-roman")) {
            return Util.toRoman(value).toLowerCase();
        }
        if (listStyle.equals("upper-roman")) {
            return Util.toRoman(value);
        }
        if (listStyle.equals("footnote")) {
            return Util.toFootnote(value);
        }
        return String.valueOf(value);
    }

    private String getCountersString(String counter, String separator, String listStyle) {
        String result = "";
        Iterator i = this.counters.iterator();
        while (i.hasNext()) {
            Map scope = (Map)i.next();
            Integer value = (Integer)scope.get(counter);
            if (value == null) continue;
            result = result + (result.equals("") ? "" : separator) + ProjectorFilter.getCounterString(value, listStyle);
        }
        return result;
    }

    private static String getElementContents(Node node) {
        return node == null ? "" : (node instanceof Text ? ((Text)node).getData() : (node instanceof org.w3c.dom.Element && (!Constants.CSS.equals(node.getNamespaceURI()) || !BEFORE.equals(node.getLocalName()) && !AFTER.equals(node.getLocalName())) ? ProjectorFilter.getElementContents(node.getFirstChild()) : "")) + ProjectorFilter.getElementContents(node.getNextSibling());
    }

    private static LexicalUnit getQuotePair(LexicalUnit unit, int quoteDepth) {
        for (int i = 0; i < quoteDepth && unit.getNextLexicalUnit().getNextLexicalUnit() != null; ++i) {
            unit = unit.getNextLexicalUnit().getNextLexicalUnit();
        }
        return unit;
    }

    private static String[] getSetNamedStringNames(Rule[] rules) {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < rules.length; ++i) {
            Property[] properties = rules[i].getProperties();
            for (int j = 0; j < properties.length; ++j) {
                if (!"string-set".equals(properties[j].getName()) || properties[j].getLexicalUnit() == null || properties[j].getLexicalUnit().getLexicalUnitType() != 35 || "none".equalsIgnoreCase(properties[j].getLexicalUnit().getStringValue())) continue;
                if (!ProjectorFilter.hasContentsIdentifier(properties[j].getLexicalUnit().getNextLexicalUnit())) {
                    result.add(properties[j].getLexicalUnit().getStringValue().toLowerCase());
                    continue;
                }
                result.remove(properties[j].getLexicalUnit().getStringValue().toLowerCase());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private Rule[] getStyleAttributeRules(String style) throws IOException, SAXException {
        final ArrayList rules = new ArrayList();
        try {
            this.parseStyleSheet(null, new StringReader("dummy{" + style + "}"), new RuleCollector.RuleEmitter(){

                public void addRule(Rule rule) {
                    rules.add(rule);
                }
            }, new ArrayList(), 0, false);
        }
        catch (MalformedURLException e) {
            throw new UndeclaredThrowableException(e);
        }
        return rules.toArray(new Rule[0]);
    }

    public URL getUserAgentStyleSheet() {
        return this.userAgentStyleSheet;
    }

    private void handleControlInformation(String namespaceURI, String localName, AttributesImpl atts) throws SAXException {
        try {
            if (atts.getValue("xml:base") != null) {
                ((Element)this.elements.peek()).baseUrl = new URL(atts.getValue("xml:base"));
            }
            ProjectorFilter.setXMLIDType(atts);
            if (Constants.XHTML == namespaceURI) {
                if (BASE == localName) {
                    if (atts.getValue("href") != null) {
                        URL base = new URL(atts.getValue("href"));
                        for (int i = 0; i < this.elements.size(); ++i) {
                            ((Element)this.elements.get(i)).baseUrl = base;
                        }
                    }
                } else if (BODY == localName) {
                    URL base = ((Element)this.elements.peek()).baseUrl;
                    if (base != null) {
                        Util.setAttribute(atts, "", "xml:base", "xml:base", base.toString());
                    }
                } else if (LINK == localName) {
                    if (ProjectorFilter.isMatchingStyleSheet(atts) && atts.getValue("href") != null) {
                        this.parseStyleSheet(atts.getValue("href"), 0, true);
                    }
                } else if (STYLE == localName && ProjectorFilter.isMatchingStyleSheet(atts)) {
                    this.collectStyleSheet = true;
                }
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private void handleFloats(Element element) throws SAXException {
        int floating = element.appliedAttributes.getIndex(Constants.CSS, "float");
        if (floating == -1) {
            return;
        }
        if (!"none".equals(element.appliedAttributes.getValue(floating))) {
            AttributesImpl floatAttributes = new AttributesImpl();
            floatAttributes.addAttribute(Constants.CSS, "float", "css:float", "CDATA", element.appliedAttributes.getValue(floating));
            super.startElement(Constants.CSS, "float", "css:float", floatAttributes);
            element.floating = true;
        }
        element.appliedAttributes.removeAttribute(floating);
    }

    private void handleGraphics(Element element) throws SAXException {
        String url;
        if ("graphic".equals(element.appliedAttributes.getValue(Constants.CSS, "display")) && (url = Util.getIndirectValue(element.appliedAttributes, "src")) != null) {
            try {
                element.appliedAttributes.setValue(element.appliedAttributes.getIndex(Constants.CSS, "src"), element.baseUrl != null ? new URL(element.baseUrl, url).toString() : url);
            }
            catch (MalformedURLException e) {
                throw new SAXException(e);
            }
        }
    }

    private static boolean hasContentsIdentifier(LexicalUnit unit) {
        return unit == null ? false : (unit.getLexicalUnitType() == 35 && "contents".equalsIgnoreCase(unit.getStringValue()) ? true : ProjectorFilter.hasContentsIdentifier(unit.getNextLexicalUnit()));
    }

    private void incrementCounter(Property counterIncrement, boolean display) {
        for (LexicalUnit i = counterIncrement.getLexicalUnit(); i != null; i = i.getNextLexicalUnit()) {
            if (i.getLexicalUnitType() != 35) continue;
            String counter = i.getStringValue().toLowerCase();
            if (!display && !"page".equals(counter)) continue;
            Map scope = this.findCounterScope(i.getStringValue());
            scope.put(counter, new Integer((Integer)scope.get(i.getStringValue()) + (i.getNextLexicalUnit() != null && i.getNextLexicalUnit().getLexicalUnitType() == 13 ? i.getNextLexicalUnit().getIntegerValue() : 1)));
        }
    }

    private void installRegionAccumulator() throws SAXException {
        Accumulator.postAccumulate(this, new Accumulator.ProcessElement(){

            public void process(org.w3c.dom.Element element, XMLFilter filter) throws SAXException {
                String pageName = element.getAttributeNS(Constants.CSS, "page");
                if (pageName.equals("") || pageName.equals("auto")) {
                    pageName = "unnamed";
                }
                element.setAttributeNS(Constants.CSS, "css:page", pageName);
                HashMap<String, org.w3c.dom.Element> regionsForPage = (HashMap<String, org.w3c.dom.Element>)((ProjectorFilter)ProjectorFilter.this).context.regions.get(pageName);
                if (regionsForPage == null) {
                    regionsForPage = new HashMap<String, org.w3c.dom.Element>();
                    ((ProjectorFilter)ProjectorFilter.this).context.regions.put(pageName, regionsForPage);
                }
                regionsForPage.put(element.getAttributeNS(Constants.CSS, "region"), element);
            }
        });
    }

    private void installStringSetAccumulator(final String name, final String value, final Map scope) throws SAXException {
        Accumulator.postAccumulate(this, new Accumulator.ProcessElement(){

            public void process(org.w3c.dom.Element element, XMLFilter filter) throws SAXException {
                String result = MessageFormat.format(value, ProjectorFilter.getElementContents(element.getFirstChild()));
                scope.put(name, result);
                ProjectorFilter.addFOMarker(element, name, result);
                DOMToContentHandler.elementToContentHandler(element, filter.getContentHandler());
            }
        });
    }

    private static boolean isMatchingStyleSheet(Attributes atts) {
        if (!"text/css".equals(atts.getValue("type")) || atts.getValue("rel") != null && !"stylesheet".equalsIgnoreCase(atts.getValue("rel").trim())) {
            return false;
        }
        if (atts.getValue("media") == null) {
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(atts.getValue("media"), ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim().toLowerCase();
            if (!"all".equals(token) && !"print".equals(token)) continue;
            return true;
        }
        return false;
    }

    private static boolean isStaticRegion(Attributes atts) {
        String region = atts.getValue(Constants.CSS, "region");
        return region != null && !"body".equalsIgnoreCase(region) && !"none".equalsIgnoreCase(region);
    }

    private void parseStyleSheet(String uri, int offset, boolean resetMatcher) throws CSSException, MalformedURLException, IOException, SAXException {
        this.parseStyleSheet(uri, null, offset, resetMatcher);
    }

    private void parseStyleSheet(Reader reader, int offset, boolean resetMatcher) throws CSSException, IOException, SAXException {
        try {
            this.parseStyleSheet(null, reader, offset, resetMatcher);
        }
        catch (MalformedURLException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private void parseStyleSheet(String uri, Reader reader, int offset, boolean resetMatcher) throws CSSException, MalformedURLException, IOException, SAXException {
        this.parseStyleSheet(uri, reader, new RuleCollector.RuleEmitter(){

            public void addRule(Rule rule) {
                ProjectorFilter.this.compiled.addRule(rule);
            }
        }, this.context.pageRules, offset, resetMatcher);
    }

    private void parseStyleSheet(String uri, Reader reader, RuleCollector.RuleEmitter ruleEmitter, List pageRules, int offset, boolean resetMatcher) throws CSSException, MalformedURLException, IOException, SAXException {
        InputSource source;
        URL base = !this.elements.isEmpty() && ((Element)this.elements.peek()).baseUrl != null ? ((Element)this.elements.peek()).baseUrl : this.baseUrl;
        Parser parser = Util.getSacParser();
        InputSource inputSource = source = reader != null ? new InputSource(reader) : new InputSource();
        source.setURI(base != null && uri != null ? new URL(base, uri).toString() : (base != null ? base.toString() : uri));
        RuleCollector collector = new RuleCollector(ruleEmitter, pageRules, source.getURI() != null ? new URL(source.getURI()) : null, this.lastRulePosition, offset);
        parser.setDocumentHandler(collector);
        parser.parseStyleSheet(source);
        this.lastRulePosition = collector.getCurrentPosition();
        if (resetMatcher) {
            this.setMatcher();
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if ("xml-stylesheet".equalsIgnoreCase(target)) {
            StringTokenizer tokenizer = new StringTokenizer(data, " ");
            String type = null;
            String uri = null;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.startsWith("type=")) {
                    type = token.substring(token.indexOf(61) + 1);
                    continue;
                }
                if (!token.startsWith("href=")) continue;
                uri = token.substring(token.indexOf(61) + 1);
            }
            if (uri != null && uri.length() > 2 && type != null && type.length() > 2 && type.substring(1, type.length() - 1).equals("text/css")) {
                try {
                    this.parseStyleSheet(uri.substring(1, uri.length() - 1), 0, true);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
        }
        super.processingInstruction(target, data);
    }

    private void repositionMatcher() throws SAXException {
        this.matcher.startDocument();
        for (int i = 1; i < this.elements.size() - 1; ++i) {
            Element element = (Element)this.elements.get(i);
            this.matcher.startElement(element.namespaceURI, element.localName, element.qName, element.attributes);
        }
    }

    private void reset() {
        this.context.pageRules.clear();
        this.compiled = new Compiled();
        this.matcher = null;
        this.baseUrl = this.defaultBaseUrl;
        this.collectStyleSheet = false;
        this.embeddedStyleSheet = "";
        this.elements.clear();
        this.counters.clear();
        this.namedStrings.clear();
        this.context.regions.clear();
    }

    private void resetCounter(Property counterReset, boolean display) {
        for (LexicalUnit i = counterReset.getLexicalUnit(); i != null; i = i.getNextLexicalUnit()) {
            if (i.getLexicalUnitType() != 35) continue;
            String counter = i.getStringValue().toLowerCase();
            if (!display && !"page".equals(counter)) continue;
            ((Map)this.counters.peek()).put(counter, new Integer(i.getNextLexicalUnit() != null && i.getNextLexicalUnit().getLexicalUnitType() == 13 ? i.getNextLexicalUnit().getIntegerValue() : 0));
        }
    }

    private static String selectCloseQuote(Element element, int quoteDepth) {
        if (element.quotes == null) {
            return "\"";
        }
        return ProjectorFilter.getQuotePair(element.quotes, quoteDepth).getNextLexicalUnit().getStringValue();
    }

    private static String selectOpenQuote(Element element, int quoteDepth) {
        if (element.quotes == null) {
            return "\"";
        }
        return ProjectorFilter.getQuotePair(element.quotes, quoteDepth).getStringValue();
    }

    private static Rule[] selectPseudoRules(Rule[] rules, String pseudoElementName) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (int i = 0; i < rules.length; ++i) {
            if (pseudoElementName != rules[i].getPseudoElementName()) continue;
            result.add(rules[i]);
        }
        return result.toArray(new Rule[0]);
    }

    private void serializeAttrFunction(LexicalUnit unit, Element element, Map prefixMap) throws SAXException {
        String value = ProjectorFilter.evaluateAttrFunction(unit, element.attributes, prefixMap);
        super.characters(value.toCharArray(), 0, value.length());
    }

    private void serializeChangeBarBegin(Attributes attributes) throws SAXException {
        if (attributes.getIndex("change-bar-class") != -1) {
            super.startElement(Constants.CSS, "change-bar-begin", "css:change-bar-begin", attributes);
            super.endElement(Constants.CSS, "change-bar-begin", "css:change-bar-begin");
        }
    }

    private void serializeChangeBarEnd(Attributes attributes) throws SAXException {
        int index = attributes.getIndex("change-bar-class");
        if (index != -1) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(attributes.getURI(index), attributes.getLocalName(index), attributes.getQName(index), attributes.getType(index), attributes.getValue(index));
            super.startElement(Constants.CSS, "change-bar-end", "css:change-bar-end", atts);
            super.endElement(Constants.CSS, "change-bar-end", "css:change-bar-end");
        }
    }

    private void serializeCounterFunction(LexicalUnit unit) throws SAXException {
        if (unit.getParameters() == null) {
            return;
        }
        String counter = unit.getParameters().getStringValue().toLowerCase();
        if ("page".equals(counter)) {
            this.serializePageNumber(ProjectorFilter.getCounterListStyle(unit));
        } else if ("pages".equals(counter)) {
            this.serializePagesTotal();
        } else {
            String value = this.evaluateCounterFunction(unit);
            super.characters(value.toCharArray(), 0, value.length());
        }
    }

    private void serializeCountersFunction(LexicalUnit unit) throws SAXException {
        String value = this.evaluateCountersFunction(unit);
        super.characters(value.toCharArray(), 0, value.length());
    }

    private void serializeFOMarkers(Rule[] rules) throws SAXException {
        String[] names = ProjectorFilter.getSetNamedStringNames(rules);
        for (int i = 0; i < names.length; ++i) {
            String value = (String)this.findNamedStringScope(names[i]).get(names[i]);
            if (value == null) continue;
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(Constants.CSS, "name", "css:name", "CDATA", names[i]);
            super.startElement(Constants.CSS, "fo-marker", "css:fo-marker", atts);
            super.characters(value.toCharArray(), 0, value.length());
            super.endElement(Constants.CSS, "fo-marker", "css:fo-marker");
        }
    }

    private void serializeFunction(LexicalUnit unit, Element element, Map prefixMap) throws SAXException {
        if ("string".equalsIgnoreCase(unit.getFunctionName())) {
            this.serializeStringFunction(unit);
        } else if ("page-ref".equalsIgnoreCase(unit.getFunctionName())) {
            this.serializePageRefFunction(unit, element, prefixMap);
        }
    }

    private void serializeQuote(LexicalUnit unit, Element element) throws SAXException {
        int[] quoteDepthReference = new int[]{this.quoteDepth};
        String value = ProjectorFilter.evaluateQuote(unit, element, quoteDepthReference);
        this.quoteDepth = quoteDepthReference[0];
        super.characters(value.toCharArray(), 0, value.length());
    }

    private void serializePageNumber(String listStyle) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(Constants.CSS, "format", "css:format", "CDATA", ProjectorFilter.convertPageFormat(listStyle));
        if (listStyle.equals("armenian") || listStyle.equals("georgian") || listStyle.equals("hebrew")) {
            attributes.addAttribute(Constants.CSS, "letter-value", "css:letter-value", "CDATA", "traditional");
        }
        super.startElement(Constants.CSS, "page-number", "css:page-number", attributes);
        super.endElement(Constants.CSS, "page-number", "css:page-number");
    }

    private void serializePageRefFunction(LexicalUnit unit, Element element, Map prefixMap) throws SAXException {
        String value;
        if (unit.getParameters() == null) {
            return;
        }
        String string = value = unit.getParameters().getLexicalUnitType() == 37 ? ProjectorFilter.evaluateAttrFunction(unit.getParameters(), element.attributes, prefixMap) : element.attributes.getValue(unit.getParameters().getStringValue());
        if (value == null) {
            return;
        }
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(Constants.CSS, "ref-id", "css:ref-id", "CDATA", value);
        super.startElement(Constants.CSS, "page-ref", "css:page-ref", attributes);
        super.endElement(Constants.CSS, "page-ref", "css:page-ref");
    }

    private void serializePagesTotal() throws SAXException {
        super.startElement(Constants.CSS, "pages-total", "css:pages-total", new AttributesImpl());
        super.endElement(Constants.CSS, "pages-total", "css:pages-total");
    }

    private void serializeString(String s) throws SAXException {
        int position = 0;
        int i = s.indexOf(10);
        while (i != -1) {
            super.characters(s.substring(position, i).toCharArray(), 0, i - position);
            super.startElement(Constants.CSS, "newline", "css:newline", new AttributesImpl());
            super.endElement(Constants.CSS, "newline", "css:newline");
            position = i + 1;
            i = s.indexOf(position, 10);
        }
        if (position < s.length()) {
            super.characters(s.substring(position).toCharArray(), 0, s.length() - position);
        }
    }

    private void serializeStringFunction(LexicalUnit unit) throws SAXException {
        if (unit.getParameters() == null) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        String name = unit.getParameters().getStringValue();
        if (name == null) {
            return;
        }
        atts.addAttribute(Constants.CSS, "name", "css:name", "CDATA", name);
        super.startElement(Constants.CSS, "retrieve-fo-marker", "css:retrieve-fo-marker", atts);
        super.endElement(Constants.CSS, "retrieve-fo-marker", "css:retrieve-fo-marker");
    }

    private void serializeUriFunction(LexicalUnit unit) throws SAXException {
        if (unit.getStringValue() == null) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(Constants.CSS, "href", "css:href", "CDATA", "url(" + unit.getStringValue() + ")");
        super.startElement(Constants.CSS, "external", "css:external", atts);
        super.endElement(Constants.CSS, "external", "css:external");
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    private AttributesImpl setCSSAttributes(Rule[] matchingRules, Attributes attributes) throws SAXException {
        Property counterIncrement = null;
        Property counterReset = null;
        boolean displayNone = false;
        AttributesImpl result = new AttributesImpl(attributes);
        Property stringSet = null;
        for (int i = 0; i < matchingRules.length; ++i) {
            Property property = matchingRules[i].getProperties()[0];
            String propertyName = property.getName();
            if (propertyName.equals("counter-increment")) {
                counterIncrement = property;
                continue;
            }
            if (propertyName.equals("counter-reset")) {
                counterReset = property;
                continue;
            }
            if (propertyName.equals("string-set")) {
                if (matchingRules[i].getPseudoElementName() != null) continue;
                stringSet = property;
                continue;
            }
            Util.setCSSAttribute(result, property, matchingRules[i].getSpecificity());
            if (!propertyName.equals("display") || !"none".equalsIgnoreCase(property.getValue())) continue;
            displayNone = true;
        }
        if (counterReset != null) {
            this.resetCounter(counterReset, !displayNone);
        }
        if (counterIncrement != null) {
            this.incrementCounter(counterIncrement, !displayNone);
        }
        if (stringSet != null && !displayNone) {
            this.setNamedString(stringSet);
        }
        return result;
    }

    private void setMatcher() throws SAXException {
        this.compiled.generateDFA();
        this.matcher = new Matcher(this.compiled);
        this.repositionMatcher();
    }

    private void setNamedString(Property stringSet) throws SAXException {
        if (stringSet.getLexicalUnit() == null || stringSet.getLexicalUnit().getLexicalUnitType() != 35 || "none".equalsIgnoreCase(stringSet.getLexicalUnit().getStringValue())) {
            return;
        }
        boolean needContents = false;
        String name = stringSet.getLexicalUnit().getStringValue().toLowerCase();
        String result = "";
        Map scope = this.findNamedStringScope(name);
        block8: for (LexicalUnit i = stringSet.getLexicalUnit().getNextLexicalUnit(); i != null; i = i.getNextLexicalUnit()) {
            switch (i.getLexicalUnitType()) {
                case 37: {
                    result = result + ProjectorFilter.evaluateAttrFunction(i, ((Element)this.elements.peek()).attributes, stringSet.getPrefixMap());
                    continue block8;
                }
                case 25: {
                    result = result + this.evaluateCounterFunction(i);
                    continue block8;
                }
                case 26: {
                    result = result + this.evaluateCountersFunction(i);
                    continue block8;
                }
                case 41: {
                    if (!"string".equalsIgnoreCase(i.getFunctionName())) continue block8;
                    result = result + this.evaluateStringFunction(i);
                    continue block8;
                }
                case 35: {
                    if ("contents".equalsIgnoreCase(i.getStringValue())) {
                        result = result + "{0}";
                        needContents = true;
                        continue block8;
                    }
                    result = result + ProjectorFilter.evaluateQuote(i, (Element)this.elements.peek(), new int[1]);
                    continue block8;
                }
                case 36: {
                    result = result + i.getStringValue();
                    continue block8;
                }
            }
        }
        if (!needContents) {
            scope.put(name, result);
        } else {
            this.installStringSetAccumulator(name, result, scope);
        }
    }

    private void setQuotes() {
        Element element = (Element)this.elements.peek();
        for (int i = 0; i < element.matchingElementRules.length; ++i) {
            Property[] properties = element.matchingElementRules[i].getProperties();
            if (!properties[0].getName().equals("quotes")) continue;
            element.quotes = properties[0].getLexicalUnit();
        }
        if (element.quotes == null || element.quotes.getLexicalUnitType() == 12) {
            element.quotes = ((Element)this.elements.get(this.elements.size() - 2)).quotes;
        }
    }

    public void setUserAgentStyleSheet(URL userAgentStyleSheet) {
        this.userAgentStyleSheet = userAgentStyleSheet;
    }

    private static void setXMLIDType(AttributesImpl atts) {
        int index = atts.getIndex("xml:id");
        if (index != -1 && !"ID".equals(atts.getType(index))) {
            atts.setType(index, "ID");
        }
    }

    private static AttributesImpl splitChangeBarAttributes(AttributesImpl attributes) {
        AttributesImpl result = new AttributesImpl();
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getLocalName(i).startsWith("change-bar-")) continue;
            if (Constants.CSS.equals(attributes.getURI(i))) {
                result.addAttribute("", attributes.getLocalName(i), attributes.getLocalName(i), attributes.getType(i), attributes.getValue(i));
            }
            attributes.removeAttribute(i--);
        }
        return result;
    }

    public void startDocument() throws SAXException {
        this.reset();
        try {
            this.parseStyleSheet(new StringReader("*{display: inline}"), -2, true);
            String htmlHeaderMark = (String)this.userAgentParameters.get("html-header-mark");
            if (htmlHeaderMark != null) {
                this.parseStyleSheet(new StringReader(htmlHeaderMark + "{string-set: component contents}"), -2, true);
            }
            this.parseStyleSheet(this.userAgentStyleSheet.toString(), -1, true);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        Element root = new Element("", "/", "/");
        root.baseUrl = this.baseUrl;
        this.elements.push(root);
        this.counters.push(new HashMap());
        this.namedStrings.push(new HashMap());
        super.startDocument();
        this.startPrefixMapping("css", Constants.CSS);
        this.startPrefixMapping("sp", Constants.SPECIF);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (namespaceURI != null) {
            namespaceURI = namespaceURI.intern();
        }
        if (localName != null) {
            localName = localName.intern();
        }
        if (qName != null) {
            qName = qName.intern();
        }
        Element element = new Element(namespaceURI, localName, qName);
        element.baseUrl = ((Element)this.elements.peek()).baseUrl;
        this.elements.push(element);
        element.attributes = new AttributesImpl(atts);
        this.handleControlInformation(namespaceURI, localName, element.attributes);
        this.matcher.startElement(namespaceURI, localName, qName, element.attributes);
        Element.access$502(element, this.appendStyleAttributeRules(this.matcher.matchingRules(), atts, namespaceURI));
        Element.access$002(element, this.matcher.matchingPseudoRules());
        this.setQuotes();
        element.appliedAttributes = this.setCSSAttributes(element.matchingElementRules, element.attributes);
        this.handleFloats(element);
        this.handleGraphics(element);
        ProjectorFilter.detectMarkers(element);
        if (ProjectorFilter.isStaticRegion(element.appliedAttributes)) {
            this.installRegionAccumulator();
        }
        this.addFirstLetterMarker(element);
        ProjectorFilter.translateId(element.appliedAttributes);
        super.startElement(namespaceURI, localName, qName, element.appliedAttributes);
        this.serializeFOMarkers(element.matchingElementRules);
        this.applyPseudoRules(element, FIRST_LETTER);
        this.applyPseudoRules(element, BEFORE);
        this.applyPseudoRules(element, FIRST_LINE);
        this.counters.push(new HashMap());
        this.namedStrings.push(new HashMap());
    }

    private static void translateId(AttributesImpl atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!"ID".equals(atts.getType(i))) continue;
            atts.setAttribute(i, Constants.XML, "id", "xml:id", "ID", atts.getValue(i));
        }
    }

    private static class Element {
        private AttributesImpl appliedAttributes;
        private AttributesImpl attributes = new AttributesImpl();
        private URL baseUrl;
        private boolean floating = false;
        private String localName;
        private Rule[] matchingElementRules = null;
        private Rule[] matchingPseudoRules = null;
        private String namespaceURI;
        private String qName;
        private LexicalUnit quotes = null;

        private Element(String namespaceURI, String localName, String qName) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.qName = qName;
        }

        static /* synthetic */ Rule[] access$502(Element x0, Rule[] x1) {
            x0.matchingElementRules = x1;
            return x1;
        }

        static /* synthetic */ Rule[] access$002(Element x0, Rule[] x1) {
            x0.matchingPseudoRules = x1;
            return x1;
        }
    }
}

