/*
 * Decompiled with CFR 0.152.
 */
package be.re.net;

import be.re.io.IOException;
import be.re.io.ReadLineInputStream;
import be.re.net.BasicUser;
import be.re.net.Headers;
import be.re.net.User;
import be.re.util.Array;
import be.re.util.UncheckedCapsule;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class Util {
    private static final char[] MARK = new char[]{'-', '_', '.', '!', '~', '*', '\'', '(', ')'};
    private static final char[] PCHAR_SPECIALS = new char[]{'@', '&', '=', '+', '$', ',', ':'};
    private static final char[] RESERVED = new char[]{';', '/', '?', ':', '@', '&', '=', '+'};
    private static ResourceBundle bundle = null;
    private static Map bundles = new HashMap();

    private static boolean compareBytes(byte[] b1, byte[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private static String escapeUriPart(String s, TestChar t) {
        int i;
        byte[] bytes = null;
        String result = "";
        try {
            bytes = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedCapsule(e);
        }
        char[] c = new char[bytes.length];
        for (i = 0; i < bytes.length; ++i) {
            c[i] = (char)(0xFF & bytes[i]);
        }
        for (i = 0; i < c.length; ++i) {
            result = result + (!t.test(c, i) ? "%" + (c[i] < '\u0010' ? "0" : "") + Integer.toHexString(c[i]) : new String(c, i, 1));
        }
        return result;
    }

    public static String escapeUriPathSegment(String segment) {
        return Util.escapeUriPart(segment, new TestChar(){

            public boolean test(char[] c, int i) {
                return (Util.isPChar(c[i]) || c[i] == ';') && (c[i] != '%' || i < c.length - 2 && be.re.util.Util.isInteger(new String(c, i + 1, 2)));
            }
        });
    }

    public static String escapeUriPathSegments(String path) {
        String result = "";
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        while (tokenizer.hasMoreTokens()) {
            result = result + (result.equals("") ? "" : "/") + Util.escapeUriPathSegment(tokenizer.nextToken());
        }
        return (path.length() > 0 && path.charAt(0) == '/' ? "/" : "") + result + (path.length() > 1 && path.charAt(path.length() - 1) == '/' ? "/" : "");
    }

    public static String escapeUriQueryString(String queryString) {
        return Util.escapeUriPart(queryString, new TestChar(){

            public boolean test(char[] c, int i) {
                return Util.isUriChar(c[i]);
            }
        });
    }

    public static String escapeUriReference(String reference) {
        return Util.escapeUriPart(reference, new TestChar(){

            public boolean test(char[] c, int i) {
                return Util.isUriChar(c[i]);
            }
        });
    }

    private static URL escapedComposedUrl(String url) throws MalformedURLException {
        return new URL(url.substring(0, url.indexOf(58)) + ":" + Util.escapedUrl(Util.extractSubUrl(url).toString()).toString() + "!/" + Util.escapeUriPathSegments(Util.extractComposedUrlEntry(url)).toString());
    }

    private static File escapedFile(File file) {
        return new File(Util.escapeUriPathSegments(file.getAbsolutePath().replace(File.separatorChar, '/')));
    }

    public static URL escapedUrl(String url) throws MalformedURLException {
        int colon = url.indexOf(58);
        if (colon != -1 && Util.isComposedUrl(url)) {
            return Util.escapedComposedUrl(url);
        }
        int pathStart = 0;
        if (colon != -1) {
            pathStart = url.indexOf(47, colon + (url.length() > colon + 2 && url.substring(colon + 1, colon + 3).equals("//") ? 3 : 1));
        }
        if (pathStart == -1) {
            return new URL(url);
        }
        int queryStart = -1;
        int referenceStart = -1;
        if ("http".equals(colon != -1 ? url.substring(0, colon) : null) || "https".equals(colon != -1 ? url.substring(0, colon) : null)) {
            queryStart = url.indexOf(63, pathStart);
            referenceStart = url.indexOf(35, queryStart);
        }
        return new URL(url.substring(0, pathStart) + Util.escapeUriPathSegments(url.substring(pathStart, queryStart != -1 ? queryStart : url.length())) + (queryStart != -1 ? "?" + Util.escapeUriQueryString(url.substring(queryStart + 1, referenceStart != -1 ? referenceStart : url.length())) : "") + (referenceStart != -1 ? "#" + Util.escapeUriReference(url.substring(referenceStart + 1)) : ""));
    }

    public static String extractComposedUrlEntry(URL url) {
        return Util.extractComposedUrlEntry(url.getFile());
    }

    public static String extractComposedUrlEntry(String url) {
        int index = url.lastIndexOf("!/");
        return index == -1 || index + 2 == url.length() ? "" : url.substring(index + 2);
    }

    public static URL extractSubUrl(URL url) throws MalformedURLException {
        if (!Util.isComposedUrl(url)) {
            throw new MalformedURLException(url.toString() + ": no sub-URL");
        }
        return new URL(url.toString().substring(url.getProtocol().length() + 1, url.toString().lastIndexOf("!/")));
    }

    public static URL extractSubUrl(String url) throws MalformedURLException {
        return Util.extractSubUrl(new URL(url));
    }

    public static URL fileToUrl(File file) {
        try {
            return Util.escapedFile(new File(file.getAbsolutePath().replace(File.separatorChar, '/'))).toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedCapsule(e);
        }
    }

    public static String getFTPFilename(URL url) {
        return Util.urlToFile(url).getPath().replace('\\', '/');
    }

    public static String getHttpReasonPhrase(int statusCode) {
        return Util.getHttpReasonPhrase(statusCode, new String[0]);
    }

    public static String getHttpReasonPhrase(int statusCode, String languageTag) {
        return Util.getHttpReasonPhrase(statusCode, new String[]{languageTag});
    }

    public static String getHttpReasonPhrase(int statusCode, String[] languageTags) {
        return Util.getResource("http_" + String.valueOf(statusCode), languageTags);
    }

    public static String getJarEntry(URL url) {
        return Util.unescapeUriSpecials(Util.extractComposedUrlEntry(url));
    }

    public static String getLastPathSegment(URL url) {
        return Util.getLastPathSegment(Util.isComposedUrl(url) ? url.getFile().substring(url.getFile().lastIndexOf("!/") + 1) : url.getFile());
    }

    public static String getLastPathSegment(String path) {
        path = path.replace('\\', '/');
        return path.substring(path.lastIndexOf(47, path.length() - 2) + 1);
    }

    public static String getResource(String key) {
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("be.re.net.res.Res");
        }
        return bundle.getString(key);
    }

    public static String getResource(String key, String languageTag) {
        return Util.getResource(key, new String[]{languageTag});
    }

    public static String getResource(String key, String[] languageTags) {
        for (int i = 0; i < languageTags.length; ++i) {
            ResourceBundle bundle = (ResourceBundle)bundles.get(be.re.util.Util.getLocale(languageTags[i]));
            if (bundle == null && (bundle = Util.getResourceBundle(languageTags[i])) != null) {
                bundles.put(be.re.util.Util.getLocale(languageTags[i]), bundle);
            }
            if (bundle == null) continue;
            return bundle.getString(key);
        }
        return Util.getResource(key);
    }

    private static ResourceBundle getResourceBundle(String language) {
        try {
            Locale locale = be.re.util.Util.getLocale(language);
            ResourceBundle result = ResourceBundle.getBundle("be.re.net.res.Res", locale);
            return result.getLocale().equals(locale) ? result : null;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static String getSegments(String path) throws MalformedURLException {
        ArrayList<String> segments = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(".")) continue;
            if (token.equals("..")) {
                if (segments.size() == 0) {
                    throw new MalformedURLException("URL specification goes outside of its root");
                }
                segments.remove(segments.size() - 1);
                continue;
            }
            segments.add(token);
        }
        String result = "";
        Iterator i = segments.iterator();
        while (i.hasNext()) {
            result = result + (result.equals("") ? "" : "/") + (String)i.next();
        }
        return result;
    }

    public static boolean hasBody(Headers headers) {
        return headers.get("Content-Length").length > 0 && Integer.parseInt(headers.get("Content-Length")[0]) > 0 || headers.get("Transfer-Encoding").length > 0;
    }

    public static long httpDate(String s) {
        String[] patterns = new String[]{"EEE, dd MMM yyyy HH:mm:ss 'GMT'", "EEEE, dd-MMM-yy HH:mm:ss 'GMT'", "EEE MMM dd HH:mm:ss yyyy", "EEE MMM  d HH:mm:ss yyyy"};
        for (int i = 0; i < patterns.length; ++i) {
            try {
                Date date = new SimpleDateFormat(patterns[i], new Locale("en", "US")).parse(s);
                if (date == null) continue;
                return date.getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public static String httpDate(long date) {
        return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", new Locale("en", "US")).format(new Date(date));
    }

    public static int httpStatusCode(String statusLine) {
        StringTokenizer tokenizer = new StringTokenizer(statusLine);
        if (tokenizer.countTokens() < 2 || !tokenizer.nextToken().startsWith("HTTP/")) {
            return -1;
        }
        try {
            return Integer.parseInt(tokenizer.nextToken());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static boolean isComposedUrl(URL url) {
        return url.toString().lastIndexOf("!/") != -1;
    }

    public static boolean isComposedUrl(String url) throws MalformedURLException {
        return Util.isComposedUrl(new URL(url));
    }

    private static boolean isPChar(char c) {
        return c == '%' || Util.isUnreserved(c) || Array.inArray(PCHAR_SPECIALS, c);
    }

    private static boolean isUnreserved(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || Array.inArray(MARK, c);
    }

    private static boolean isUriChar(char c) {
        return c == '%' || Util.isUnreserved(c) || Array.inArray(RESERVED, c);
    }

    public static boolean isUrl(String s) {
        try {
            return s != null && new URL(s) != null;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static Headers readHeaders(ReadLineInputStream in) throws java.io.IOException {
        byte[] line;
        Headers headers = new Headers();
        while ((line = in.readLine()) != null && line.length > 0) {
            String s = new String(line);
            if (s.indexOf(58) == -1) continue;
            headers.add(s.substring(0, s.indexOf(58)).trim(), s.substring(s.indexOf(58) + 1).trim());
        }
        return headers;
    }

    public static URL resolvePath(URL url) throws MalformedURLException {
        if (Util.isComposedUrl(url)) {
            try {
                String segments = Util.getSegments(Util.extractComposedUrlEntry(url));
                segments = (segments.length() == 0 || segments.charAt(0) != '/' ? "/" : "") + segments;
                return new URL(url.getProtocol() + ":" + Util.resolvePath(Util.extractSubUrl(url)).toString() + "!" + segments + (segments.charAt(segments.length() - 1) != '/' && url.toString().charAt(url.toString().length() - 1) == '/' ? "/" : ""));
            }
            catch (MalformedURLException e) {
                return Util.resolvePath(new URL(Util.extractSubUrl(url).toString() + "/" + Util.extractComposedUrlEntry(url)));
            }
        }
        String segments = Util.getSegments(url.getFile());
        segments = (segments.length() == 0 || segments.charAt(0) != '/' ? "/" : "") + segments;
        return new URL(new URL(url.getProtocol() + ":" + (url.getAuthority() != null ? "//" + url.getAuthority() : "")), segments + (segments.charAt(segments.length() - 1) != '/' && url.toString().charAt(url.toString().length() - 1) == '/' ? "/" : "") + (url.getRef() != null ? "#" + url.getRef() : ""));
    }

    public static URL setScheme(URL url, String scheme) throws MalformedURLException {
        try {
            return new URI(scheme, url.getUserInfo(), Util.unescapeUriSpecials(url.getHost()), url.getPort(), Util.unescapeUriSpecials(url.getPath()), Util.unescapeUriSpecials(url.getQuery()), Util.unescapeUriSpecials(url.getRef())).toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    public static URL setUserInfo(URL url, String userInfo) throws MalformedURLException {
        try {
            return new URI(url.getProtocol(), userInfo, Util.unescapeUriSpecials(url.getHost()), url.getPort(), Util.unescapeUriSpecials(url.getPath()), Util.unescapeUriSpecials(url.getQuery()), Util.unescapeUriSpecials(url.getRef())).toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    public static URL stripUserInfo(URL url) {
        try {
            return new URL(url.getProtocol() + ":" + (url.getHost() != null ? "//" + url.getHost() : "") + (url.getPort() != -1 ? ":" + String.valueOf(url.getPort()) : "") + url.getFile() + (url.getRef() != null ? "#" + url.getRef() : ""));
        }
        catch (MalformedURLException e) {
            throw new UncheckedCapsule(e);
        }
    }

    public static void testUrl(URL url) throws java.io.IOException {
        try {
            url.openStream().close();
        }
        catch (Exception e) {
            throw new IOException("The URL \"" + url.toString() + "\" can't be opened.", e);
        }
    }

    public static String unescapeUriSpecials(String s) {
        if (s == null) {
            return null;
        }
        int count = 0;
        byte[] result = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '%' && s.length() - i > 2) {
                result[count++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                i += 2;
                continue;
            }
            result[count++] = (byte)s.charAt(i);
        }
        try {
            return new String(result, 0, count, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedCapsule(e);
        }
    }

    public static File urlToFile(URL url) {
        return new File(Util.unescapeUriSpecials(url.getFile()));
    }

    public static User userFromUrl(URL url) {
        BasicUser user = new BasicUser();
        String userInfo = url.getUserInfo();
        if (userInfo == null) {
            return user;
        }
        StringTokenizer tokenizer = new StringTokenizer(userInfo, ":");
        if (tokenizer.hasMoreTokens()) {
            user.setUsername(tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            user.setPassword(tokenizer.nextToken());
        }
        return user;
    }

    private static interface TestChar {
        public boolean test(char[] var1, int var2);
    }
}

